using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace zadatak_2
{
    internal class Program
    {
        public struct t
        {
            public long x;
            public long y;
            public t(long x, long y)
            {
                this.x = x;
                this.y = y;
            }
        }
        private static long or(t a, t b, t c)
        {
            return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        }
        private static long povrsina(List<t> om)
        {
            long p = 0;
            int n = om.Count;
            for (int i = 0; i < n; i++)
            {
                int sl = (i + 1) % n;
                p += om[i].x * om[sl].y;
                p -= om[i].y * om[sl].x;
            }
            return Math.Abs(p) / 2;
        }
        private static List<t> o(List<t> tacke)
        {
            if (tacke.Count < 3)
                return new List<t>();
            tacke.Sort((a, b) =>
            {
                if (a.x != b.x)
                    return a.x.CompareTo(b.x);
                return a.y.CompareTo(b.y);
            });
            List<t> n = new List<t>();
            foreach (var x in tacke)
            {
                while (n.Count >= 2 && or(n[n.Count - 2], n[n.Count - 1], x) <= 0)
                    n.RemoveAt(n.Count - 1);
                n.Add(x);
            }
            List<t> v = new List<t>();
            for (int i = tacke.Count - 1; i >= 0; i--)
            {
                var x = tacke[i];
                while (v.Count >= 2 && or(v[v.Count - 2], v[v.Count - 1], x) <= 0)
                    v.RemoveAt(v.Count - 1);
                v.Add(x);
            }
            v.RemoveAt(v.Count - 1);
            n.RemoveAt(n.Count - 1);
            n.AddRange(v);
            return n;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<t> tacke = new List<t>();
            for (int i = 0; i < n; i++)
            {
                string[] unos = Console.ReadLine().Split();
                long x = long.Parse(unos[0]);
                long y = long.Parse(unos[1]);
                tacke.Add(new t(x, y));
            }
            List<t> om = o(tacke);
            if (om.Count < 3)
            {
                Console.WriteLine(0);
                return;
            }
            long min = long.MaxValue;
            for (int i = 0; i < om.Count; i++)
            {
                List<t> t = new List<t>(tacke);
                t.Remove(om[i]);
                List<t> nom = o(t);
                long P = povrsina(nom);
                min = Math.Min(min, P);
            }
            Console.WriteLine(min);
        }
    }
}